/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.tooltip;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.event.common.TagsUpdatedCallback;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.TagKeySerializer;
import slimeknights.mantle.fluid.tooltip.FluidUnit;
import slimeknights.mantle.fluid.tooltip.FluidUnitList;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.mantle.util.JsonHelper;

public class FluidTooltipHandler
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Logger log = LogManager.getLogger(FluidTooltipHandler.class);
    public static final class_2561 HOLD_SHIFT = Mantle.makeComponent("gui", "fluid.hold_shift").method_27692(class_124.field_1080);
    public static final String FOLDER = "mantle/fluid_tooltips";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(FluidIngredient.class, (Object)FluidIngredient.SERIALIZER).registerTypeAdapter(class_6862.class, new TagKeySerializer(class_7924.field_41270)).setPrettyPrinting().disableHtmlEscaping().create();
    public static final class_2960 DEFAULT_ID = Mantle.getResource("fallback");
    private static final FluidUnit BUCKET = new FluidUnit(Mantle.makeDescriptionId("gui", "fluid.bucket"), 10000L);
    private static final FluidUnit MILLIBUCKET = new FluidUnit(Mantle.makeDescriptionId("gui", "fluid.millibucket"), 81L);
    private static final FluidUnit DROPLET = new FluidUnit(Mantle.makeDescriptionId("gui", "fluid.droplet"), 1L);
    private static final FluidUnitList DEFAULT_LIST = new FluidUnitList(null, List.of(BUCKET, DROPLET));
    public static final BiConsumer<Long, List<class_2561>> BUCKET_FORMATTER = FluidTooltipHandler::appendBuckets;
    public static final FluidTooltipHandler INSTANCE = new FluidTooltipHandler();
    private FluidUnitList fallback = DEFAULT_LIST;
    private Map<class_2960, FluidUnitList> unitLists = Collections.emptyMap();
    private final Map<class_3611, FluidUnitList> listCache = new HashMap<class_3611, FluidUnitList>();

    public static void init() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)INSTANCE);
        TagsUpdatedCallback.EVENT.register(registries -> FluidTooltipHandler.INSTANCE.listCache.clear());
    }

    private FluidTooltipHandler() {
        super(GSON, FOLDER);
    }

    @Nullable
    private static FluidUnitList loadList(class_2960 key, JsonElement json) {
        try {
            return (FluidUnitList)GSON.fromJson(json, FluidUnitList.class);
        }
        catch (JsonSyntaxException e) {
            log.error("Failed to load fluid container transfer info from {}", (Object)key, (Object)e);
            return null;
        }
    }

    protected void apply(Map<class_2960, JsonElement> splashList, class_3300 manager, class_3695 profiler) {
        long time = System.nanoTime();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        HashMap<class_2960, class_2960> redirects = new HashMap<class_2960, class_2960>();
        for (Map.Entry<class_2960, JsonElement> entry : splashList.entrySet()) {
            JsonObject object;
            class_2960 key = entry.getKey();
            JsonElement element = entry.getValue();
            if (element.isJsonObject() && (object = element.getAsJsonObject()).has("redirect")) {
                class_2960 redirect = JsonHelper.getResourceLocation(object, "redirect");
                redirects.put(key, redirect);
                continue;
            }
            FluidUnitList list = FluidTooltipHandler.loadList(key, element);
            if (list == null) continue;
            builder.put((Object)key, (Object)list);
        }
        ImmutableMap mapBeforeRedirects = builder.build();
        builder = ImmutableMap.builder();
        builder.putAll((Map)mapBeforeRedirects);
        for (Map.Entry entry : redirects.entrySet()) {
            class_2960 from = (class_2960)entry.getKey();
            class_2960 to = (class_2960)entry.getValue();
            FluidUnitList list = (FluidUnitList)mapBeforeRedirects.get(to);
            if (list != null) {
                builder.put((Object)from, (Object)list);
                continue;
            }
            log.error("Invalid fluid tooltip redirect {} as unit list {} does not exist", (Object)from, (Object)to);
        }
        this.unitLists = builder.build();
        this.fallback = this.unitLists.getOrDefault(DEFAULT_ID, DEFAULT_LIST);
        this.listCache.clear();
        log.info("Loaded {} fluid unit lists in {} ms", (Object)this.listCache.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    private FluidUnitList getUnitList(class_3611 fluid) {
        FluidUnitList cached = this.listCache.get(fluid);
        if (cached != null) {
            return cached;
        }
        for (FluidUnitList list : this.unitLists.values()) {
            if (!list.matches(fluid)) continue;
            this.listCache.put(fluid, list);
            return list;
        }
        this.listCache.put(fluid, this.fallback);
        return this.fallback;
    }

    private FluidUnitList getUnitList(class_2960 id) {
        return this.unitLists.getOrDefault(id, this.fallback);
    }

    public static List<class_2561> getFluidTooltip(FluidStack fluid) {
        return FluidTooltipHandler.getFluidTooltip(fluid, fluid.getAmount());
    }

    public static List<class_2561> getFluidTooltip(FluidStack fluid, long amount) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        tooltip.add((class_2561)fluid.getDisplayName().method_27662().method_27692(class_124.field_1068));
        FluidTooltipHandler.appendMaterial(fluid.getFluid(), amount, tooltip);
        FabricLoader.getInstance().getModContainer(Objects.requireNonNull(class_7923.field_41173.method_10221((Object)fluid.getFluid())).method_12836()).map(container -> container.getMetadata().getName()).ifPresent(name -> tooltip.add((class_2561)class_2561.method_43470((String)name).method_27695(new class_124[]{class_124.field_1078, class_124.field_1056})));
        return tooltip;
    }

    public static void appendMaterial(FluidStack fluid, List<class_2561> tooltip) {
        FluidTooltipHandler.appendMaterial(fluid.getFluid(), fluid.getAmount(), tooltip);
    }

    public static void appendMaterial(class_3611 fluid, long amount, List<class_2561> tooltip) {
        if (FluidTooltipHandler.appendMaterialNoShift(fluid, amount, tooltip)) {
            FluidTooltipHandler.appendShift(tooltip);
        }
    }

    public static boolean appendMaterialNoShift(class_3611 fluid, long original, List<class_2561> tooltip) {
        if (SafeClientAccess.getTooltipKey() != TooltipKey.SHIFT) {
            long amount = original;
            amount = INSTANCE.getUnitList(fluid).getText(tooltip, amount);
            MILLIBUCKET.getText(tooltip, amount);
            return FluidTooltipHandler.INSTANCE.listCache.get(fluid) != FluidTooltipHandler.INSTANCE.fallback;
        }
        FluidTooltipHandler.appendBuckets(original, tooltip);
        return false;
    }

    public static void appendShift(List<class_2561> tooltip) {
        if (!SafeClientAccess.getTooltipKey().isShiftOrUnknown()) {
            tooltip.add((class_2561)class_2561.method_43473());
            tooltip.add(HOLD_SHIFT);
        }
    }

    public static void appendNamedList(class_2960 id, long amount, List<class_2561> tooltip) {
        amount = INSTANCE.getUnitList(id).getText(tooltip, amount);
        FluidTooltipHandler.appendBuckets(amount, tooltip);
    }

    public static void appendBuckets(long amount, List<class_2561> tooltip) {
        amount = FluidTooltipHandler.INSTANCE.fallback.getText(tooltip, amount);
        MILLIBUCKET.getText(tooltip, amount);
    }

    public class_2960 getFabricId() {
        return Mantle.getResource("fluid_tooltip_handler");
    }
}

